#define PATH_TRACING_RESOLUTION 1.0 //[0.1 0.2 0.25 0.33 0.5 0.667 0.75 1.0] //lower quality bounce light for way better performance

#define DIFFUSE_BOUNCE_LIGHT 20 //[ 0 1 2 3 4 5 6 7 8 9 10 11 12 15 20 30 40 50 60 70 80 90 100 150 200 300] //AMOUNT OF RAYTRACED AMBIENT SKY DIFFUSE LIGHTING

#define SPECULAR_BOUNCE_LIGHT 20 //[ 0 1 2 3 4 5 6 7 8 9 10 11 12 15 20 30 40 50 60 70 80 90 100 150 200 300]  //AMOUNT OF RAYTRACED AMBIENT SKY DIFFUSE LIGHTING

#define BOUNCE_LIGHT_M 1 //[0.2 0.5 0.75 1 2 3 4 5 6 7 8 9 10 20 30 40]

#define BOUNCE_MORE 3 //[0 1 2 3] // Amount of light bounces . Very Expensive! 

#define KILL_SWITCH 0 //[0 1 5 10 20 24 30 40 50 60] // Fps for Kill Switch . Light Simulation will stop below this fps! So you can still navugate menus and turn it down . RED BOX in top left, 	It will toggle per frame so you still might get lagged out
//requires
 //uniform float frameTime;
 
 
 #define RAY_ACCELERATION 0.2 //[0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.5 0.6 0.7 1.0] //Speeds up rays to maintain precise close reflections and better ray distance at the same time . too high might hurt ray accuracy
 #define REFINER_STEPS_RAY 6 //[0 1 2 3 4 5 6 7 8 9 10] //fractal refinement of ray collission position

#define RAY_DIST 1 //[0 1 2 3 4 5 6 7 8 9 10] //further ray distance . this may break close reflections at low step count

#define SKY_RAY_NUM_W 0 // [0 1 2 3 4 5 6 7 8 9 10] // more looks better but is slower . ray number = 4 * w * h + 1 . w wedges in convergence cone

#define SKY_RAY_NUM_H 0 // [0 1 2 3 4 5 6 7 8 9 10] // more looks better but is slower . ray number = 4 * w * h + 1 .  h layers of petals in convergence cone
 
  #define DIFFUSE_THE_RAYS  9 //[0 1 2 3 4 5 6 7 8 9 10 15 20 25 30 40] //softness and stability of diffuse lighting. helps with low samples . can be inaccurate and cause bloom 
  
    #define DIFFUSE_THE_RAYS_SPEC  9 //[0 1 2 3 4 5 6 7 8 9 10 15 20 25 30 40] //softness and stability of SPECULAR lighting. helps with low samples . can be inaccurate and cause bloom . 
  
  
  #define PBR_RAY_STEPS_SKY 0 // [0 5 10 20 30 40 50 60 70 80 90] //how accurately and expensively to propagate light rays 

 #define METAL_SMOOTHER 0.0 //[ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] 
 #define METAL_REFLECTIVE 0.0 //[ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //increase metal reflectivity
 
 #define USE_MINECRAFT_TORCH_LIGHTING 1.0 //[ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.5 2.0 3.0 4.0 5.0] //Minecraft ambient light from torches and light blocks . is divided by number of light bounces to not overpower
 
 #if BOUNCE_MORE > 1
	#define TORCH_DIV_BOUNCES USE_MINECRAFT_TORCH_LIGHTING / BOUNCE_MORE
 #else
	#define TORCH_DIV_BOUNCES USE_MINECRAFT_TORCH_LIGHTING 
 #endif
 
 #define RAY_BIAS 0.0001 //[0.0001 0.0]
 #define NOISE_AMOUNT_IN_RAYS 2 //[0 1 2 3 4 5 6 7 8 9 10]
 
 #define SCREEN_TANGENT 1 //[0 1] //buggy test, don't use!
 
  #define GEN_NORMAL_MAP 0 //[0 1] //generate a normal map for blank textures to play better with the light simulation . probably won't work in texture filtering range

  #define DEBUG_GEN_NORMAL_MAP 0 //[0 1] //buggy test, don't use!

 #define N_BLANK_R 0.5 //[0.0 0.5 1.0] //VALUE FOR MISSING TEXTURES TO OVERRIDE
  #define N_BLANK_G 0.5 //[0.0 0.5 1.0] //VALUE FOR MISSING TEXTURES TO OVERRIDE
   #define N_BLANK_B 1.0 //[0.0 0.5 1.0] //VALUE FOR MISSING TEXTURES TO OVERRIDE
    #define N_BLANK_A 1.0 //[0.0 0.5 1.0] //VALUE FOR MISSING TEXTURES TO OVERRIDE
   
    #define S_BLANK_R 1.0 //[0.0 1.0] //VALUE FOR MISSING TEXTURES TO OVERRIDE
  #define S_BLANK_G 1.0 //[0.0 1.0] //VALUE FOR MISSING TEXTURES TO OVERRIDE
   #define S_BLANK_B 1.0 //[0.0 1.0] //VALUE FOR MISSING TEXTURES TO OVERRIDE
    #define S_BLANK_A 1.0 //[0.0 1.0] //VALUE FOR MISSING TEXTURES TO OVERRIDE


 #define CURVE_LENS 1 //[0 1 2 3] //buggy test, don't use!
 
 #define HANDHELD_REDUCE_DIFFUSE_BY_REFLECTIVITY_ 0.9 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //MAKE HAND HELF METALS LESS DARK
  #define HANDHELD_AMBIENT_LIGHT_FLAT 1.0 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //1.0 is realistic . 0 is because i don't think most artists think about it
 #define TEXTURE_FILTER_HAND 1 //[0 1 ]
 
  #define REDUCE_DIFFUSE_BY_REFLECTIVITY_METALS 0.0 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //1.0 is realistic . 0 is default because i don't think most artists think about it

#define HALF_RAYS 0 //[0 1]//buggy test, combine diffuse and specular
#define ASSUMED_DEPTH 1.0 //[ 0.1 0.2 0.5 0.7 1.0 1.5 2.0 3.0 4.0 5.0 10.0 100.0 10000.0] //assumed depth of things in screenspace effects . higher gets rid of halos and collides better, but may create occclussion where it shouldn't be . 
	#define ASSUMED_DEPTH_DYNAMIC 1 //[0 1] // increases assumed depth based on distance from camera . usually looks a lot better
						
#define DEBUG_CPF 0 //[0 1]// debug views , not for gameplay!

#define FIX_SSS_LIGHT_LEAK 1 //[0 1] //turning this off will make things directly on top of honey or leaves not cast shadows into it . off will make forest canopies brighter as branches and trunks will not cast shadows on leaves . off may save performance

 #define RAY_FULLY_CONVERGE 1 //[0 1]//fully converge ray cones . may waste performance . may look better with crisper reflections

#define RAY_NUM_W 1 // [0 1 2 3 4 5 6 7 8 9 10] // more looks better but is slower . ray number = 4 * w * h + 1 . w wedges in convergence cone

#define RAY_NUM_H 3 // [0 1 2 3 4 5 6 7 8 9 10] // more looks better but is slower . ray number = 4 * w * h + 1 .  h layers of petals in convergence cone

 #define ROUGH_FRESNEL 0.7 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //FRESNEL amount for rough materials
 #define ROUGH_FRESNEL_EXPONENTIAL 0 // [ 0 1] //FRESNEL for rough materials use an extra exponential curvature . 0 no . 1 exponentially less fresnel but still full at parallel angles
 #define ROUGH_FRESNEL_EXPONENT 0.5 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //FRESNEL for rough materials use an extra exponential curvature . 0 no . 1 exponentially less fresnel but still full at parallel angles . degree of effect
 
 #define CURVE_ASPECT 1.0 // [-3.0 -2.0 -1.0 -0.5 -0.25 -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.5 2.0 2.5 3.0]
 
  #define REDUCE_DIFFUSE_BY_REFLECTIVITY_ 0.0 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //1.0 is realistic . 0 is because i don't think most artists think about it
 
 
#define DIRTY_WATER 0.05 //[ 0.0 0.001 0.002 0.003 0.005 0.007 0.01 0.02 0.03 0.05 0.07 0.1 0.12 0.15 0.17 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.92 0.95 0.97 0.99 1.0] //linear rate of DIRT color per meter (block) . 1.0 is 1 block . 0.1 is 10 blocks
 #define DIRTY_WATER_R 0.1 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
  #define DIRTY_WATER_G 0.1 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
   #define DIRTY_WATER_B 0.1 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

#define WATER_ABSORB_R 0.3 //[ 0.0 0.001 0.002 0.003 0.005 0.007 0.01 0.02 0.03 0.05 0.07 0.1 0.12 0.15 0.17 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.92 0.95 0.97 0.99 1.0] //linear rate of light color absorption per meter (block) . 1.0 is 1 block . 0.1 is 10 blocks
#define WATER_ABSORB_G 0.05 //[ 0.0 0.001 0.002 0.003 0.005 0.007 0.01 0.02 0.03 0.05 0.07 0.1 0.12 0.15 0.17 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.92 0.95 0.97 0.99 1.0] //linear rate of light color absorption per meter (block) . 1.0 is 1 block . 0.1 is 10 blocks
#define WATER_ABSORB_B 0.01 //[ 0.0 0.001 0.002 0.003 0.005 0.007 0.01 0.02 0.03 0.05 0.07 0.1 0.12 0.15 0.17 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.92 0.95 0.97 0.99 1.0] //linear rate of light color absorption per meter (block) . 1.0 is 1 block . 0.1 is 10 blocks
#define WATER_SKIN_R 0.99 //[ 0.0 0.001 0.002 0.003 0.005 0.007 0.01 0.02 0.03 0.05 0.07 0.1 0.12 0.15 0.17 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.92 0.95 0.97 0.99 1.0] //color allowed through water skin, tints even shallow water 
#define WATER_SKIN_G 1.0 //[ 0.0 0.001 0.002 0.003 0.005 0.007 0.01 0.02 0.03 0.05 0.07 0.1 0.12 0.15 0.17 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.92 0.95 0.97 0.99 1.0] //color allowed through water skin, tints even shallow water 
#define WATER_SKIN_B 1.0 //[ 0.0 0.001 0.002 0.003 0.005 0.007 0.01 0.02 0.03 0.05 0.07 0.1 0.12 0.15 0.17 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.92 0.95 0.97 0.99 1.0] //color allowed through water skin, tints even shallow water 
#define ONLY_DRAW_DH 0 //[0 1]
#define BUGGY_DH_SHADING 2 //[0 1 2]
#define DISABLE_SKY_RAY_TRACE 1 //[0 1]
#define NO_DH_SHADOWS 1 //[0 1]

#define ACCURATE_TRACING 0 //[0 1]//accurate ray tracing angles that cost more fps

#define BORDER_FOG_CLOUDS 4 //[0 1 2 3 4 5 6 7 8 9 10] // amount of the fog distance in tenths to have clouds in . 0 or too low will create pop-in! 10 will be very smooth fade in with clouds in it . 10 was the old default

#define LIGHTNING_FLASHES 1 //[0 1]
#define CTMPOMFIX_VERSION 2 //[0 1 2]
#define HAND_HELD_TORCH 1 //[0 1]
#define HAND_HELD_TORCH_RANGE 10.0 //[5.0 10.0 15.0 20.0 30.0]
#define TORCH_BRIGHTNESS 10.0 //[1.0 2.0 3.0 5.0 7.0 10.0 15.0 20.0]
#define TORCH_LIGHT_3D 2 //[0 1 2]
#define TORCH_HORIZONTAL_OFFSET 0.7 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.3 1.4 1.5 1.7 2.0] 
#define TORCH_V_OFFSET 0.2 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.3 1.4 1.5 1.7 2.0]